IF OBJECT_ID('P_GT_APLICA_TRIBUTACAO') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_GT_APLICA_TRIBUTACAO;
    END;

GO

CREATE PROCEDURE [dbo].[P_GT_APLICA_TRIBUTACAO] (@CD_REGIAO_FISCAL INT, @CD_PROD INT, @CD_USU INT) AS
BEGIN

	SET NOCOUNT ON

	DECLARE @CD_CTR_GRUPO INT
	DECLARE @CD_CTR_PROD BIGINT
	DECLARE @ERRO VARCHAR(8000)
	DECLARE @ACHOU_GRUPO_ATUALIZAR TINYINT = 0
	DECLARE @CFOP VARCHAR(10)


	SELECT *
	FROM EST_PROD_NCM_NATUREZA_RECEITA
	ORDER BY DT_CAD DESC


	CREATE TABLE #GT_RETORNO_APLICACAO (
		CD_CTR BIGINT
		,CD_EMP INT  
		,CD_PROD INT  
		,DS_PROD VARCHAR(150)
		,CD_REGIAO_FISCAL INT  
		,UF_REGIAO_FISCAL VARCHAR(2)
		,CD_CTR_CABECALHO BIGINT  
		,CD_CTR_PROD BIGINT  
		,CD_PROD_RETORNADO VARCHAR(50)
		,NR_NCM VARCHAR(50)
		,NR_CEST VARCHAR(20)
		,LISTA_PROD VARCHAR(2)
		,TIPO_PROD VARCHAR(2)
		,CTR_PMC VARCHAR(2)
		,IMPOSTO_IMP MONEY  
		,CST_ENT INT
		,CST_SAI INT
		,ALIQ_PIS MONEY  
		,ALIQ_COFINS MONEY  
		,NRI VARCHAR(10)
		,APARO_LEGAL VARCHAR(1000)
		,UF VARCHAR(2)
		,CFOP VARCHAR(10)
		,TP_MOV INT
		,CD_CTR_REGRA_UF BIGINT  
		,CD_CARAC INT
		,CD_OPER_MVA INT
		,FINALIDADE SMALLINT  
		,CFOPST VARCHAR(10)
		,CST INT
		,CD_TRIB_CST INT
		,CSOSN VARCHAR(10)
		,ALIQ_ICMS_INTERNA MONEY  
		,ALIQ_ICMS_INTER_EST MONEY  
		,PERC_REDU_BC MONEY  
		,PERC_REDU_BC_ST MONEY  
		,PERC_REDU_BC_INTER_EST MONEY  
		,ALIQ_ICMS_ST MONEY  
		,PERC_IVA MONEY  
		,PERC_IVA_AJUSTADO MONEY  
		,PERC_FCP MONEY  
		,CD_BENEF VARCHAR(50)
		,PERC_DIFERIMENTO MONEY  
		,PERC_ISENCAO MONEY  
		,ANTECIPADO CHAR  
		,DESONERADO CHAR  
		,ISENTO CHAR
		,AMP_LEGAL VARCHAR(1000)
		,COD_REGRA INT
		,SIMPLES_NACIONAL TINYINT
		,TP_TRANSA TINYINT)
			


	INSERT INTO
		#GT_RETORNO_APLICACAO
	SELECT
		ROW_NUMBER() OVER(ORDER BY EST_PROD.CD_EMP, EST_PROD.CD_PROD ) AS CD_CTR
		,EST_PROD.CD_EMP
		,EST_PROD.CD_PROD 
		,EST_PROD.DS_PROD 
		,PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL
		,UF_REGIAO_FISCAL.UF AS UF_REGIAO_FISCAL
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE.CD_CTR AS CD_CTR_CABECALHO

		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR AS CD_CTR_PROD
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_PROD AS CD_PROD_RETORNADO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.NR_NCM
		,REPLACE(REPLACE(GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.NR_CEST, '.', ''), ',', '') AS NR_CEST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.LISTA_PROD
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.TIPO_PROD
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CTR_PMC
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.IMPOSTO_IMP
		,CASE WHEN ISNUMERIC(GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.CST_ENT) = 1 THEN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.CST_ENT ELSE 0 END
		,CASE WHEN ISNUMERIC(GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.CST_SAI) = 1 THEN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.CST_SAI ELSE 0 END
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.ALIQ_PIS
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.ALIQ_COFINS
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.NRI
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.APARO_LEGAL
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.UF
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.CFOP
		,-1 AS TP_MOV
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_CTR_REGRA_UF
		,CASE WHEN ISNUMERIC(GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_CARAC) = 1 THEN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_CARAC ELSE 0 END AS CD_CARAC
		,-1 AS CD_OPER_MVA
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.FINALIDADE
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CFOPST
		,CASE WHEN ISNUMERIC(GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CST) = 1 THEN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CST ELSE 0 END AS CST
		,-1 AS CD_TRIB_CST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CSOSN
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ALIQ_ICMS_INTERNA
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ALIQ_ICMS_INTER_EST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_REDU_BC
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_REDU_BC_ST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_REDU_BC_INTER_EST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ALIQ_ICMS_ST
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_IVA
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_IVA_AJUSTADO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_FCP
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_BENEF
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_DIFERIMENTO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.PERC_ISENCAO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ANTECIPADO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.DESONERADO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.ISENTO
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.AMP_LEGAL
		,GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.COD_REGRA

		,CASE WHEN GT_ENVIO_PERFIL_DEST.SIMPLES_NACIONAL = 'S' THEN 1 ELSE 0 END AS SIMPLES_NACIONAL

		,CASE WHEN LEFT(GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.CFOP, 1) IN (1,2) THEN
			0
		ELSE
			1
		END AS TP_TRANSA

	FROM 
		GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE.CD_CTR 
		INNER JOIN EST_PROD ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_EMP = EST_PROD.CD_EMP 
			AND GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_PROD = EST_PROD.CD_PROD 
		INNER JOIN GT_RETORNO_CABECALHO ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR_RETORNO = GT_RETORNO_CABECALHO.CD_CTR 
		INNER JOIN GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO ON 
			GT_RETORNO_CABECALHO.CD_CTR = GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO.CD_CTR_RETORNO 
		INNER JOIN GT_ENVIO_EMITENTE ON 
			GT_ENVIO_EMITENTE_GT_RETORNO_CABECALHO.CD_CTR_ENVIO = GT_ENVIO_EMITENTE.CD_CTR 
		INNER JOIN GT_ENVIO_PERFIL_DEST ON 
			GT_ENVIO_EMITENTE.CD_CTR = GT_ENVIO_PERFIL_DEST.CD_CTR_ENVIO 
		INNER JOIN PRC_REGIAO_FISCAL ON 
			GT_ENVIO_EMITENTE.CD_REGIAO_FISCAL = PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL
		INNER JOIN (
			SELECT
				PRC_REGIAO_FISCAL_PRC_FILIAL.CD_REGIAO_FISCAL,
				GLB_CID.UF
			FROM
				PRC_REGIAO_FISCAL_PRC_FILIAL
				INNER JOIN PRC_FILIAL ON
					PRC_REGIAO_FISCAL_PRC_FILIAL.CD_EMP = PRC_FILIAL.CD_EMP
					AND PRC_REGIAO_FISCAL_PRC_FILIAL.CD_FILIAL = PRC_FILIAL.CD_FILIAL
				INNER JOIN GLB_CID ON
					PRC_FILIAL.CD_CID = GLB_CID.CD_CID
			GROUP BY
				PRC_REGIAO_FISCAL_PRC_FILIAL.CD_REGIAO_FISCAL,
				GLB_CID.UF) UF_REGIAO_FISCAL ON
			PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL = UF_REGIAO_FISCAL.CD_REGIAO_FISCAL
		
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PISCOFINS.CD_CTR_GRP_PROD 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_EAN ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_EAN.CD_CTR_GRP_PROD 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_IPI ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_IPI.CD_CTR_GRP_PROD 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA.CD_CTR_GRP_PROD 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.CD_CTR_REGRA 
		INNER JOIN GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC ON 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF.CD_CTR = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_REGRA_UF_CARAC.CD_CTR_REGRA_UF 
	WHERE
		EST_PROD.CD_EMP = 1
		AND PRC_REGIAO_FISCAL.CD_REGIAO_FISCAL = @CD_REGIAO_FISCAL
		AND EST_PROD.CD_PROD = @CD_PROD
	
	CREATE INDEX IX_GT_APLICA_TRIB_TEMP ON #GT_RETORNO_APLICACAO(CD_EMP, CD_CTR, CD_TRIB_CST, UF, TP_MOV, CD_OPER_MVA, SIMPLES_NACIONAL)

	--ATUALIZANDO O CDIGO DA CST PELA TABELA EST_TRIB_CST
	--NO FOI COLOCADO NO INNER JOIN PORQUE PODE DUPLICAR OS REGISTROS
	UPDATE
		RET_TRIB
	SET
		CD_TRIB_CST = CST.CD_TRIB_CST
	FROM
		#GT_RETORNO_APLICACAO RET_TRIB
		INNER JOIN EST_TRIB_CST CST ON 
			RET_TRIB.CST = CST.CD_TRIB_CST


	--ATUALIZANDO O CDIGO DA CD_OPER_MVA PELA TABELA EST_TRIB_OPER_MVA
	--NO FOI COLOCADO NO INNER JOIN PORQUE PODE DUPLICAR OS REGISTROS
	UPDATE
		RET_TRIB
	SET
		CD_OPER_MVA = MVA.CD_OPER_MVA
	FROM
		#GT_RETORNO_APLICACAO RET_TRIB
		INNER JOIN EST_TRIB_OPER_MVA MVA ON 
			RET_TRIB.CD_CARAC = MVA.CARAC_TRIB


	--ATUALIZANDO TP_MOV PELA TABELA GLB_NT_OP_PROD
	--NO FOI COLOCADO NO INNER JOIN PORQUE PODE DUPLICAR OS REGISTROS
	UPDATE
		RET_TRIB
	SET
		TP_MOV = CFOP.TP_MOV
	FROM
		#GT_RETORNO_APLICACAO RET_TRIB
		INNER JOIN GLB_NT_OP_PROD CFOP ON 
			RIGHT(RET_TRIB.CFOP, 3) = CAST(CFOP.NR_CFOP_PROD AS VARCHAR(10)) COLLATE SQL_Latin1_General_CP1_CI_AS
			AND CFOP.ORIG_DEST IN (0 ,3)
			AND CFOP.TP_MOV_OP_TRANSA IN (SELECT CASE WHEN LEFT(RET_TRIB.CFOP, 1) IN (5, 6) THEN 1 ELSE 0 END UNION SELECT 2)
			AND CFOP.STS = 0

	DELETE FROM
		GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE
	WHERE
		EXISTS (
			SELECT
				*
			FROM
				#GT_RETORNO_APLICACAO
			WHERE
				(TP_MOV = -1
				OR CD_TRIB_CST = -1
				OR CD_OPER_MVA = -1)
				AND CD_CTR_CABECALHO = GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE.CD_CTR)
		
	DELETE FROM
		#GT_RETORNO_APLICACAO
	WHERE
		TP_MOV = -1
		OR CD_TRIB_CST = -1
		OR CD_OPER_MVA = -1



	BEGIN TRAN

	--ATUALIZANDO O CODIGO DE BENEFICIO FISCAL
	UPDATE
		P
	SET
		P.CD_BENEF = RET_TRIB.CD_BENEF
	FROM
		EST_PROD_COD_BENEF P
		INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
			P.CD_EMP = RET_TRIB.CD_EMP
			AND P.CD_PROD = RET_TRIB.CD_PROD
			AND P.UF = RET_TRIB.UF COLLATE SQL_Latin1_General_CP1_CI_AS
	WHERE
		COALESCE(RET_TRIB.CD_BENEF, '') <> '';



	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO
			EST_PROD_COD_BENEF (CD_EMP, CD_PROD, UF,CD_BENEF, MOTIVO_DESONERADO_ICMS, ICMS_DESONERADO)
		SELECT TOP 1
			CD_EMP,
			CD_PROD,
			UF,
			CD_BENEF,
			9,
			1
		FROM
			#GT_RETORNO_APLICACAO
		WHERE
			COALESCE(CD_BENEF, '') <> '';
	END


	--ATUALIZANDO AS INFORMACOES DE PIS/COFINS DE SAIDA
	UPDATE
		P
	SET	
		P.FLAG_EXCECAO_PIS_COFINS = 1
		,P.FLAG_TRIB_PIS_COFINS_PROD = 1
		,TIPO_TRIBUTACAO_PIS_COFINS = GLB_TRIB_PIS_COFINS_REGIME.TIPO_TRIBUTACAO 
		,CD_CST_PIS_SAIDA = GLB_TRIB_PIS_COFINS_REGIME.CD_CST 
		,CD_CST_COFINS_SAIDA = GLB_TRIB_PIS_COFINS_REGIME.CD_CST
	FROM 
		GLB_TRIB_PIS_COFINS_REGIME 
		INNER JOIN #GT_RETORNO_APLICACAO CST_SAI ON
			GLB_TRIB_PIS_COFINS_REGIME.CD_CST = CST_SAI.CST_SAI
			AND GLB_TRIB_PIS_COFINS_REGIME.TP_TRANSA = 1
		INNER JOIN EST_PROD P ON
			CST_SAI.CD_EMP = P.CD_EMP
			AND CST_SAI.CD_PROD = P.CD_PROD
	WHERE
		CST_SAI.UF_REGIAO_FISCAL = CST_SAI.UF COLLATE SQL_Latin1_General_CP1_CI_AS

	--ATUALIZANDO AS INFORMACOES DE PIS/COFINS DE ENTRADA
	UPDATE
		P
	SET	
		P.FLAG_EXCECAO_PIS_COFINS = 1
		,P.FLAG_TRIB_PIS_COFINS_PROD = 1
		,TIPO_TRIBUTACAO_PIS_COFINS_ENTRADA = GLB_TRIB_PIS_COFINS_REGIME.TIPO_TRIBUTACAO
		,CD_CST_PIS_ENTRADA = GLB_TRIB_PIS_COFINS_REGIME.CD_CST 
		,CD_CST_COFINS_ENTRADA = GLB_TRIB_PIS_COFINS_REGIME.CD_CST 
	FROM 
		GLB_TRIB_PIS_COFINS_REGIME
		INNER JOIN #GT_RETORNO_APLICACAO CST_ENT ON
			GLB_TRIB_PIS_COFINS_REGIME.CD_CST = CST_ENT.CST_ENT
			AND GLB_TRIB_PIS_COFINS_REGIME.TP_TRANSA = 0
		INNER JOIN EST_PROD P ON
			CST_ENT.CD_EMP = P.CD_EMP
			AND CST_ENT.CD_PROD = P.CD_PROD
	WHERE
		CST_ENT.UF_REGIAO_FISCAL = CST_ENT.UF COLLATE SQL_Latin1_General_CP1_CI_AS


	--ATUALIZANDO O CODIGO DE RECEITA PIS/COFINS
	UPDATE
		P
	SET	
		P.CD_NAT_RECEITA = CST_SAI.NRI
	FROM 
		#GT_RETORNO_APLICACAO CST_SAI
		INNER JOIN EST_PROD_NCM_NATUREZA_RECEITA P ON
			CST_SAI.CD_EMP = P.CD_EMP
			AND CST_SAI.CD_PROD = P.CD_PROD
	WHERE
		CST_SAI.UF_REGIAO_FISCAL = CST_SAI.UF COLLATE SQL_Latin1_General_CP1_CI_AS

	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO
			EST_PROD_NCM_NATUREZA_RECEITA (CD_EMP,CD_PROD,CD_NAT_RECEITA,NR_NCM,CD_USU,DT_CAD,FLAG_EXCECAO_NAT_RECEITA)
		SELECT TOP 1
			CD_EMP,
			CD_PROD,
			NRI,
			NR_NCM,
			@CD_USU,
			GETDATE(),
			1
		FROM
			#GT_RETORNO_APLICACAO G
		WHERE
			COALESCE(NR_NCM, '') <> ''
			AND COALESCE(NRI, '') <> ''
			AND NOT EXISTS (SELECT 1 FROM EST_PROD_NCM_NATUREZA_RECEITA R
							WHERE R.CD_EMP = G.CD_EMP
							AND R.CD_PROD = G.CD_PROD
							AND R.CD_NAT_RECEITA = G.NRI)
	END
		

	DECLARE 
		CURSOR_GRUPOS
	CURSOR FOR
	SELECT 
		EST_TRIB_CONF_GRP.CD_CTR AS CD_CTR_GRUPO
	FROM 
		EST_PROD_EST_TRIB_CONF_GRP
		INNER JOIN EST_TRIB_CONF_GRP ON
			EST_PROD_EST_TRIB_CONF_GRP.CD_EMP = EST_TRIB_CONF_GRP.CD_EMP
			AND EST_PROD_EST_TRIB_CONF_GRP.CD_CTR = EST_TRIB_CONF_GRP.CD_CTR
	WHERE
		EST_TRIB_CONF_GRP.CD_EMP = 1
		AND EST_PROD_EST_TRIB_CONF_GRP.CD_PROD = @CD_PROD
		AND EST_TRIB_CONF_GRP.CD_REGIAO_FISCAL = @CD_REGIAO_FISCAL
		AND EST_TRIB_CONF_GRP.FLAG_TRIB_DARE = 0
		AND EST_TRIB_CONF_GRP.FLAG_GRP_FORN = 0

	OPEN CURSOR_GRUPOS

	

	FETCH NEXT FROM CURSOR_GRUPOS INTO @CD_CTR_GRUPO

	BEGIN TRY
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @ACHOU_GRUPO_ATUALIZAR = 1
			
			UPDATE
				EST_TRIB_CONF_GRP
			SET
				CD_USU = @CD_USU,
				DT_ULT_ALT = GETDATE()
			WHERE
				CD_EMP = 1
				AND CD_CTR = @CD_CTR_GRUPO;

			INSERT INTO
				EST_TRIB_CONF_GRP_AUDITORIA (
					CD_EMP
					,CD_CTR
					,CD_USU
					,DT_EVENTO
					,HISTORICO)
				VALUES
					(1, @CD_CTR_GRUPO, @CD_USU, GETDATE(), 'ALTERACAO DE GRUPO PELO GESTOR TRIBUTARIO');
				
			DECLARE 
				CURSOR_PRODUTO
			CURSOR
				FOR
			SELECT
				CD_CTR
			FROM
				#GT_RETORNO_APLICACAO

			OPEN CURSOR_PRODUTO

			FETCH NEXT FROM CURSOR_PRODUTO INTO @CD_CTR_PROD

			WHILE @@FETCH_STATUS = 0 
			BEGIN

				--IF NOT EXISTS (
				--	SELECT
				--		*
				--	FROM
				--		EST_PROD_CEST_CADASTRO
				--		INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
				--			EST_PROD_CEST_CADASTRO.NR_CEST = RET_TRIB.NR_CEST
				--	WHERE
				--		RET_TRIB.CD_CTR = @CD_CTR_PROD)
				--BEGIN
				--	INSERT INTO 
				--		EST_PROD_CEST_CADASTRO
				--END

				UPDATE
					EST_PROD
				SET
					NR_NCM = RET_TRIB.NR_NCM
					,NR_CEST = RET_TRIB.NR_CEST
				FROM
					EST_PROD P
					INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
						P.CD_EMP = RET_TRIB.CD_EMP
						AND P.CD_PROD = RET_TRIB.CD_PROD
						AND RET_TRIB.CD_CTR = @CD_CTR_PROD;


				--APGANDO O HISTORICO ANTERIOR PARA REVERSAO, PRESERVAR SOMENTE O LTIMO
				DELETE FROM
					EST_TRIB_CONF_GRP_CPL_GT_BKP
				WHERE
					EXISTS (
						SELECT
							*
						FROM
							#GT_RETORNO_APLICACAO RET_TRIB
						WHERE
							RET_TRIB.CD_CTR = @CD_CTR_PROD
							AND EST_TRIB_CONF_GRP_CPL_GT_BKP.CD_EMP = RET_TRIB.CD_EMP
							AND EST_TRIB_CONF_GRP_CPL_GT_BKP.CD_TRIB_CST = RET_TRIB.CD_TRIB_CST
							AND EST_TRIB_CONF_GRP_CPL_GT_BKP.UF = RET_TRIB.UF COLLATE SQL_Latin1_General_CP1_CI_AS
							AND EST_TRIB_CONF_GRP_CPL_GT_BKP.TP_MOV = RET_TRIB.TP_MOV
							AND EST_TRIB_CONF_GRP_CPL_GT_BKP.TP_TRANSA = RET_TRIB.TP_TRANSA
							AND EST_TRIB_CONF_GRP_CPL_GT_BKP.CD_OPER_MVA = RET_TRIB.CD_OPER_MVA
							AND EST_TRIB_CONF_GRP_CPL_GT_BKP.TIPO_REGIME_EMPRESA = RET_TRIB.SIMPLES_NACIONAL
							AND RET_TRIB.TP_MOV >=0
							AND RET_TRIB.CD_OPER_MVA >=0
							AND RET_TRIB.CD_TRIB_CST >=0)

				INSERT INTO
					EST_TRIB_CONF_GRP_CPL_GT_BKP
						(CD_EMP
						,CD_CTR
						,CD_TRIB_CST
						,UF
						,TP_MOV
						,TP_TRANSA
						,TP_LISTA
						,PERC_RED
						,PERC_ICMS
						,TP_RED_BASE_IMP
						,PERC_RED_SUBS_TRIB
						,PERC_RED_ESTORNO
						,CST_PIS
						,CST_COFINS
						,PERC_REPASSE
						,PERC_IBPT
						,TP_GERACAO_DARE
						,MVA_AJUSTADO
						,CD_OPER_MVA
						,PERC_ICMS_ORIGEM
						,PERC_RED_IMPORTADO
						,PERC_RED_SUBS_TRIB_IMPORTADO
						,TIPO_REGIME_EMPRESA
						,OBS_GRUPO_TRIB_NF
						,PERC_ICMS_DIFAL_EXCESSAO
						,FCOP
						,PERC_DIFERIMENTO
						,ORIGEM_TRIB
						,TIPO_TRANSACAO_GT)
				SELECT TOP 1
					CPL.CD_EMP
					,CPL.CD_CTR
					,CPL.CD_TRIB_CST
					,CPL.UF
					,CPL.TP_MOV
					,CPL.TP_TRANSA
					,CPL.TP_LISTA
					,CPL.PERC_RED
					,CPL.PERC_ICMS
					,CPL.TP_RED_BASE_IMP
					,CPL.PERC_RED_SUBS_TRIB
					,CPL.PERC_RED_ESTORNO
					,CPL.CST_PIS
					,CPL.CST_COFINS
					,CPL.PERC_REPASSE
					,CPL.PERC_IBPT
					,CPL.TP_GERACAO_DARE
					,CPL.MVA_AJUSTADO
					,CPL.CD_OPER_MVA
					,CPL.PERC_ICMS_ORIGEM
					,CPL.PERC_RED_IMPORTADO
					,CPL.PERC_RED_SUBS_TRIB_IMPORTADO
					,CPL.TIPO_REGIME_EMPRESA
					,CPL.OBS_GRUPO_TRIB_NF
					,CPL.PERC_ICMS_DIFAL_EXCESSAO
					,CPL.FCOP
					,CPL.PERC_DIFERIMENTO
					,CPL.ORIGEM_TRIB
					,'ATUALIZACAO'
				FROM
					EST_TRIB_CONF_GRP_CPL CPL
				WHERE
					CPL.CD_CTR = @CD_CTR_GRUPO
					AND EXISTS (
						SELECT
							*
						FROM
							#GT_RETORNO_APLICACAO RET_TRIB
						WHERE
							RET_TRIB.CD_CTR = @CD_CTR_PROD
							AND CPL.CD_EMP = RET_TRIB.CD_EMP
							AND CPL.CD_TRIB_CST = RET_TRIB.CD_TRIB_CST
							AND CPL.UF = RET_TRIB.UF COLLATE SQL_Latin1_General_CP1_CI_AS
							AND CPL.TP_MOV = RET_TRIB.TP_MOV
							AND CPL.CD_OPER_MVA = RET_TRIB.CD_OPER_MVA
							AND CPL.TIPO_REGIME_EMPRESA = RET_TRIB.SIMPLES_NACIONAL
							AND CPL.TP_TRANSA = RET_TRIB.TP_TRANSA
							AND RET_TRIB.TP_MOV >=0
							AND RET_TRIB.CD_OPER_MVA >=0
							AND RET_TRIB.CD_TRIB_CST >=0)

					AND NOT EXISTS (
						SELECT
							*
						FROM
							EST_TRIB_CONF_GRP_CPL_GT_BKP BKP
						WHERE
							CPL.CD_EMP = BKP.CD_EMP
							AND CPL.CD_CTR = BKP.CD_CTR
							AND CPL.CD_TRIB_CST = BKP.CD_TRIB_CST
							AND CPL.UF = BKP.UF COLLATE SQL_Latin1_General_CP1_CI_AS
							AND CPL.TP_MOV = BKP.TP_MOV
							AND CPL.TP_TRANSA = BKP.TP_TRANSA
							AND CPL.CD_OPER_MVA = BKP.CD_OPER_MVA
							AND CPL.TIPO_REGIME_EMPRESA = BKP.TIPO_REGIME_EMPRESA)

				IF @@ROWCOUNT > 0
				BEGIN
					UPDATE
						CPL
					SET
						CD_TRIB_CST = RET_TRIB.CD_TRIB_CST
						--,TP_LISTA = RET_TRIB.LISTA_PROD
						,PERC_RED = RET_TRIB.PERC_REDU_BC
						,PERC_ICMS = RET_TRIB.ALIQ_ICMS_INTERNA
						--,TP_RED_BASE_IMP = RET_TRIB.?
						,PERC_RED_SUBS_TRIB = RET_TRIB.PERC_REDU_BC_ST
						--,PERC_RED_ESTORNO = RET_TRIB.?
						,CST_PIS = RET_TRIB.CST_SAI
						--,CST_COFINS = RET_TRIB.?
						--,PERC_REPASSE = RET_TRIB.?
						--,PERC_IBPT = RET_TRIB.?
						,MVA_AJUSTADO = CASE WHEN RET_TRIB.PERC_IVA_AJUSTADO > 0 THEN 1 ELSE 0 END
						,PERC_ICMS_ORIGEM = RET_TRIB.ALIQ_ICMS_INTERNA
						--,PERC_RED_IMPORTADO = RET_TRIB.?
						--,PERC_RED_SUBS_TRIB_IMPORTADO = RET_TRIB.?
						--,PERC_ICMS_DIFAL_EXCESSAO = RET_TRIB.?
						,FCOP = CASE WHEN RET_TRIB.PERC_FCP = 0 THEN 0 ELSE 1 END
						,PERC_DIFERIMENTO = RET_TRIB.PERC_DIFERIMENTO
						,ORIGEM_TRIB = 1
					FROM
						EST_TRIB_CONF_GRP_CPL CPL
						INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
							RET_TRIB.CD_CTR = @CD_CTR_PROD
							AND CPL.CD_EMP = RET_TRIB.CD_EMP
							AND CPL.CD_TRIB_CST = RET_TRIB.CD_TRIB_CST
							AND CPL.UF = RET_TRIB.UF COLLATE SQL_Latin1_General_CP1_CI_AS
							AND CPL.TP_MOV = RET_TRIB.TP_MOV
							AND CPL.TP_TRANSA = RET_TRIB.TP_TRANSA
							AND CPL.CD_OPER_MVA = RET_TRIB.TP_MOV
							AND CPL.TIPO_REGIME_EMPRESA = RET_TRIB.SIMPLES_NACIONAL

				END ELSE
				BEGIN
					INSERT INTO
						EST_TRIB_CONF_GRP_CPL
							(CD_EMP
							,CD_CTR
							,CD_TRIB_CST
							,UF
							,TP_MOV
							,TP_TRANSA
							,TP_LISTA
							,PERC_RED
							,PERC_ICMS
							,TP_RED_BASE_IMP
							,PERC_RED_SUBS_TRIB
							,PERC_RED_ESTORNO
							,CST_PIS
							,CST_COFINS
							,PERC_REPASSE
							,PERC_IBPT
							,TP_GERACAO_DARE
							,MVA_AJUSTADO
							,CD_OPER_MVA
							,PERC_ICMS_ORIGEM
							,PERC_RED_IMPORTADO
							,PERC_RED_SUBS_TRIB_IMPORTADO
							,TIPO_REGIME_EMPRESA
							,OBS_GRUPO_TRIB_NF
							,PERC_ICMS_DIFAL_EXCESSAO
							,FCOP
							,PERC_DIFERIMENTO
							,ORIGEM_TRIB)
					SELECT
						1 AS CD_EMP
						,@CD_CTR_GRUPO AS CD_CTR
						,RET_TRIB.CD_TRIB_CST
						,RET_TRIB.UF
						,RET_TRIB.TP_MOV
						,RET_TRIB.TP_TRANSA
						,EST_TRIB_CONF_GRP.TP_LISTA
						,RET_TRIB.PERC_REDU_BC AS PERC_RED
						,RET_TRIB.ALIQ_ICMS_INTERNA AS PERC_ICMS
						,0 AS TP_RED_BASE_IMP
						,RET_TRIB.PERC_REDU_BC_ST AS PERC_RED_SUBS_TRIB
						,0 AS PERC_RED_ESTORNO
						,RET_TRIB.CST_SAI AS CST_PIS
						,0 AS CST_COFINS
						,0 AS PERC_REPASSE
						,0 AS PERC_IBPT
						,3 AS TP_GERACAO_DARE
						,CASE WHEN RET_TRIB.PERC_IVA_AJUSTADO > 0 THEN 1 ELSE 0 END AS MVA_AJUSTADO
						,RET_TRIB.CD_OPER_MVA
						,RET_TRIB.ALIQ_ICMS_INTERNA AS PERC_ICMS_ORIGEM
						,0 AS PERC_RED_IMPORTADO
						,0 AS PERC_RED_SUBS_TRIB_IMPORTADO
						,RET_TRIB.SIMPLES_NACIONAL AS TIPO_REGIME_EMPRESA
						,'' AS OBS_GRUPO_TRIB_NF
						,0 AS PERC_ICMS_DIFAL_EXCESSAO
						,CASE WHEN RET_TRIB.PERC_FCP = 0 THEN 0 ELSE 1 END AS FCOP
						,RET_TRIB.PERC_DIFERIMENTO AS PERC_DIFERIMENTO
						,1 AS ORIGEM_TRIB
					FROM
						#GT_RETORNO_APLICACAO RET_TRIB
						INNER JOIN EST_TRIB_CONF_GRP ON
							EST_TRIB_CONF_GRP.CD_CTR = @CD_CTR_GRUPO
					WHERE
						RET_TRIB.CD_CTR = @CD_CTR_PROD
						AND NOT EXISTS (
							SELECT
								*
							FROM
								EST_TRIB_CONF_GRP_CPL CPL
							WHERE
								CPL.CD_EMP = RET_TRIB.CD_EMP
								AND CPL.CD_CTR = @CD_CTR_GRUPO
								AND CPL.CD_TRIB_CST = RET_TRIB.CD_TRIB_CST
								AND CPL.UF = RET_TRIB.UF COLLATE SQL_Latin1_General_CP1_CI_AS
								AND CPL.TP_MOV = RET_TRIB.TP_MOV
								AND CPL.TP_TRANSA = RET_TRIB.TP_TRANSA
								AND CPL.CD_OPER_MVA = RET_TRIB.CD_OPER_MVA
								AND CPL.TIPO_REGIME_EMPRESA = RET_TRIB.SIMPLES_NACIONAL)

					IF @@ROWCOUNT > 0
					BEGIN
						INSERT INTO
							EST_TRIB_CONF_GRP_CPL_GT_BKP
								(CD_EMP
								,CD_CTR
								,CD_TRIB_CST
								,UF
								,TP_MOV
								,TP_TRANSA
								,TP_LISTA
								,PERC_RED
								,PERC_ICMS
								,TP_RED_BASE_IMP
								,PERC_RED_SUBS_TRIB
								,PERC_RED_ESTORNO
								,CST_PIS
								,CST_COFINS
								,PERC_REPASSE
								,PERC_IBPT
								,TP_GERACAO_DARE
								,MVA_AJUSTADO
								,CD_OPER_MVA
								,PERC_ICMS_ORIGEM
								,PERC_RED_IMPORTADO
								,PERC_RED_SUBS_TRIB_IMPORTADO
								,TIPO_REGIME_EMPRESA
								,OBS_GRUPO_TRIB_NF
								,PERC_ICMS_DIFAL_EXCESSAO
								,FCOP
								,PERC_DIFERIMENTO
								,ORIGEM_TRIB
								,TIPO_TRANSACAO_GT)
						SELECT
							1 AS CD_EMP
							,@CD_CTR_GRUPO AS CD_CTR
							,RET_TRIB.CD_TRIB_CST
							,RET_TRIB.UF
							,RET_TRIB.TP_MOV
							,RET_TRIB.TP_TRANSA
							,EST_TRIB_CONF_GRP.TP_LISTA
							,RET_TRIB.PERC_REDU_BC AS PERC_RED
							,RET_TRIB.ALIQ_ICMS_INTERNA AS PERC_ICMS
							,0 AS TP_RED_BASE_IMP
							,RET_TRIB.PERC_REDU_BC_ST AS PERC_RED_SUBS_TRIB
							,0 AS PERC_RED_ESTORNO
							,RET_TRIB.CST_SAI AS CST_PIS
							,0 AS CST_COFINS
							,0 AS PERC_REPASSE
							,0 AS PERC_IBPT
							,3 AS TP_GERACAO_DARE
							,CASE WHEN RET_TRIB.PERC_IVA_AJUSTADO > 0 THEN 1 ELSE 0 END AS MVA_AJUSTADO
							,RET_TRIB.CD_OPER_MVA
							,RET_TRIB.ALIQ_ICMS_INTERNA AS PERC_ICMS_ORIGEM
							,0 AS PERC_RED_IMPORTADO
							,0 AS PERC_RED_SUBS_TRIB_IMPORTADO
							,RET_TRIB.SIMPLES_NACIONAL AS TIPO_REGIME_EMPRESA
							,'' AS OBS_GRUPO_TRIB_NF
							,0 AS PERC_ICMS_DIFAL_EXCESSAO
							,CASE WHEN RET_TRIB.PERC_FCP = 0 THEN 0 ELSE 1 END AS FCOP
							,RET_TRIB.PERC_DIFERIMENTO AS PERC_DIFERIMENTO
							,1 AS ORIGEM_TRIB
							,'INSERCAO' AS ORIGEM_TRIB
						FROM
							#GT_RETORNO_APLICACAO RET_TRIB
							INNER JOIN EST_TRIB_CONF_GRP ON
								EST_TRIB_CONF_GRP.CD_CTR = @CD_CTR_GRUPO
						WHERE
							RET_TRIB.CD_CTR = @CD_CTR_PROD
					END
				END

				SELECT TOP 1 @CFOP = CFOP FROM #GT_RETORNO_APLICACAO WHERE CD_CTR = @CD_CTR_PROD 
				EXEC P_GT_APLICA_TRIBUTACAO_TABELA_MVA @CD_CTR_PROD, @CD_USU, @CD_CTR_GRUPO, @CFOP

				FETCH NEXT FROM CURSOR_PRODUTO INTO @CD_CTR_PROD
			END

			CLOSE CURSOR_PRODUTO
			DEALLOCATE CURSOR_PRODUTO

			FETCH NEXT FROM CURSOR_GRUPOS INTO @CD_CTR_GRUPO
		END 
		

		IF @ACHOU_GRUPO_ATUALIZAR = 0
		BEGIN
			print 'NAO EXISTE GRUPO VINCULADO AO PRODUTO. CRIANDO UM NOVO'
			--SE NAO ACHOU GRUPO NENHUM VINCULADO AO PRODUTO, TENTA LOCALIZAR ALGUM GRUPO PELO COD_REGRA OU CRIA GRUPOS NOVOS 
			DECLARE
				CURSOR_PRODUTO
			CURSOR
				FOR
			SELECT
				CD_CTR
			FROM
				#GT_RETORNO_APLICACAO

			OPEN CURSOR_PRODUTO

			FETCH NEXT FROM CURSOR_PRODUTO INTO @CD_CTR_PROD

			DECLARE @CRIOU_GRUPO TINYINT = 0
			DECLARE @ACHOU_GRUPO_COD_REGRA TINYINT = 0
			DECLARE @CD_CTR_GRP_NOVO INT

			WHILE @@FETCH_STATUS = 0 AND @ACHOU_GRUPO_COD_REGRA = 0
			BEGIN
				IF @CRIOU_GRUPO = 0
				BEGIN

					--COMO NO TEM GRUPO VINCULA DO PRODUTO, ATUALIZA LISTA, NCM E CEST
					UPDATE
						EST_PROD
					SET
						LISTA_PROD = CASE RET_TRIB.LISTA_PROD 
							WHEN 'P' THEN 0 -- POSITIVA
							WHEN 'N' THEN 1 -- NEGATIVA
							WHEN 'U' THEN 2 -- NEUTRA
							WHEN 'O' THEN 3 -- SEM LISTA
							ELSE 3
						END
						,NR_NCM = RET_TRIB.NR_NCM
						,NR_CEST = RET_TRIB.NR_CEST
					FROM
						EST_PROD P
						INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
							P.CD_EMP = RET_TRIB.CD_EMP
							AND P.CD_PROD = RET_TRIB.CD_PROD
							AND RET_TRIB.CD_CTR = @CD_CTR_PROD;

					--VERIFICA SE TEM ALGUM GRUPO VINCULADO ATRAVS DO COD_REGRA
					--SE NO TEM, INSERE UM NOVO GRUPO
					--SE TEM, UTILIZA O GRUPO ENCONTRADO PELO COD_REGRA

					SET @CD_CTR_GRP_NOVO = -1

					SELECT 
						@CD_CTR_GRP_NOVO = COALESCE(T.CD_CTR, -1)
					FROM
						EST_TRIB_CONF_GRP_COD_REGRA_GT T
						INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
							T.CD_EMP = RET_TRIB.CD_EMP
							AND T.COD_REGRA = RET_TRIB.COD_REGRA
						INNER JOIN EST_TRIB_CONF_GRP G ON
							T.CD_EMP = G.CD_EMP
							AND T.CD_CTR = G.CD_CTR
					WHERE
						RET_TRIB.CD_CTR = @CD_CTR_PROD
						AND G.CD_REGIAO_FISCAL = @CD_REGIAO_FISCAL

					--IF NOT EXISTS (
					--	SELECT 
					--		*
					--	FROM
					--		EST_TRIB_CONF_GRP_COD_REGRA_GT T
					--		INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
					--			T.CD_EMP = RET_TRIB.CD_EMP
					--			AND T.COD_REGRA = RET_TRIB.COD_REGRA
					--		INNER JOIN EST_TRIB_CONF_GRP G ON
					--			T.CD_EMP = G.CD_EMP
					--			AND T.CD_CTR = G.CD_CTR
					--	WHERE
					--		RET_TRIB.CD_CTR = @CD_CTR_PROD
					--		AND G.CD_REGIAO_FISCAL = @CD_REGIAO_FISCAL)

					IF @CD_CTR_GRP_NOVO = -1
					BEGIN
						
						SET @CD_CTR_GRP_NOVO = COALESCE((SELECT MAX(CD_CTR) FROM EST_TRIB_CONF_GRP WHERE CD_EMP = 1), 0) + 1

						INSERT INTO
							EST_TRIB_CONF_GRP
								(CD_EMP
								,CD_CTR
								,DS_CONF_TRIB
								,CD_REGIAO_FISCAL
								,FLAG_TRIB_DARE
								,CD_USU
								,DT_CAD
								,DT_ULT_ALT
								,TP_LISTA
								,CD_CLASS_FISC
								,FLAG_GRP_FORN)
						SELECT
							CD_EMP
							,@CD_CTR_GRP_NOVO AS CD_CTR
							,'GESTOR TRIBUTARIO - LISTA: ' + 
								CASE RET_TRIB.LISTA_PROD 
									WHEN 'P' THEN 'POSITIVA'
									WHEN 'N' THEN 'NEGATIVA'
									WHEN 'U' THEN 'NEUTRA'
									WHEN 'O' THEN 'SEM LISTA'
									ELSE 'SEM LISTA'
								END
								+ ' - NCM: ' + NR_NCM AS DS_CONF_TRIB
							,@CD_REGIAO_FISCAL
							,0 AS FLAG_TRIB_DARE
							,@CD_USU
							,CONVERT(DATE, GETDATE())
							,NULL
							,CASE RET_TRIB.LISTA_PROD 
								WHEN 'P' THEN 0 -- POSITIVA
								WHEN 'N' THEN 1 -- NEGATIVA
								WHEN 'U' THEN 2 -- NEUTRA
								WHEN 'O' THEN 3 -- SEM LISTA
								ELSE 3
							END AS TP_LISTA
							,0 AS CD_CLASS_FISC
							,0 AS FLAG_GRP_FORN
						FROM
							#GT_RETORNO_APLICACAO RET_TRIB
						WHERE
							CD_EMP = 1
							AND CD_CTR = @CD_CTR_PROD;

						INSERT INTO
							EST_TRIB_CONF_GRP_AUDITORIA (
								CD_EMP
								,CD_CTR
								,CD_USU
								,DT_EVENTO
								,HISTORICO)
							VALUES
								(1, @CD_CTR_GRP_NOVO, @CD_USU, GETDATE(), 'CRIACAO DE GRUPO PELO GESTOR TRIBUTARIO');


						--DELETA O VNCULO DO NCM COM QUALQUER OUTRO GRUPO EXISTENTE
						DELETE FROM
							EST_TRIB_CONF_GRP_NCM
						FROM
							EST_TRIB_CONF_GRP_NCM P
							INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
								P.CD_EMP = RET_TRIB.CD_EMP
								AND RET_TRIB.CD_CTR = @CD_CTR_PROD
						WHERE
							P.NR_NCM = RET_TRIB.NR_NCM COLLATE SQL_Latin1_General_CP1_CI_AS;

						--VINCULA O NCM AO GRUPO NOVO CRIADO
						INSERT INTO
							EST_TRIB_CONF_GRP_NCM
						SELECT
							CD_EMP
							,@CD_CTR_GRP_NOVO
							,NR_NCM
						FROM
							#GT_RETORNO_APLICACAO
						WHERE
							CD_CTR = @CD_CTR_PROD;


						--VINCULA O GRUPO NOVO CRIADO A COD_REGRA
						INSERT INTO
							EST_TRIB_CONF_GRP_COD_REGRA_GT
						SELECT
							CD_EMP
							,@CD_CTR_GRP_NOVO
							,COD_REGRA
						FROM
							#GT_RETORNO_APLICACAO
						WHERE
							CD_CTR = @CD_CTR_PROD;


						--VINCULA O GRUPO NOVO CRIADO AO PRODUTO
						INSERT INTO
							EST_PROD_EST_TRIB_CONF_GRP
						SELECT
							RET_TRIB.CD_EMP
							,RET_TRIB.CD_PROD
							,@CD_CTR_GRP_NOVO
						FROM
							#GT_RETORNO_APLICACAO RET_TRIB
						WHERE
							RET_TRIB.CD_CTR = @CD_CTR_PROD
						GROUP BY
							RET_TRIB.CD_EMP
							,RET_TRIB.CD_PROD

						SET @CRIOU_GRUPO = 1
					END ELSE
					BEGIN
						--SE ACHOU ALGUM GRUPO, INSERE O VINCULO DO PRODUTO COM O GRUPO ENCONTRADO ATRAVES DO COD_REGRA
						INSERT INTO
							EST_PROD_EST_TRIB_CONF_GRP
						SELECT
							T.CD_EMP
							,RET_TRIB.CD_PROD
							,T.CD_CTR
						FROM
							EST_TRIB_CONF_GRP_COD_REGRA_GT T
							INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
								T.CD_EMP = RET_TRIB.CD_EMP
								AND T.COD_REGRA = RET_TRIB.COD_REGRA
							INNER JOIN EST_TRIB_CONF_GRP G ON
								T.CD_EMP = G.CD_EMP
								AND T.CD_CTR = G.CD_CTR
						WHERE
							RET_TRIB.CD_CTR = @CD_CTR_PROD
							AND G.CD_REGIAO_FISCAL = @CD_REGIAO_FISCAL
						GROUP BY
							T.CD_EMP
							,RET_TRIB.CD_PROD
							,T.CD_CTR;

						INSERT INTO
							EST_TRIB_CONF_GRP_AUDITORIA (
								CD_EMP
								,CD_CTR
								,CD_USU
								,DT_EVENTO
								,HISTORICO)
						SELECT
							1
							,T.CD_CTR
							,@CD_USU
							,GETDATE()
							,'VINCULO DE GRUPO PELO GESTOR TRIBUTARIO ATRAVES DO COD_REGRA. PRODUTO: ' + CAST(RET_TRIB.CD_PROD AS VARCHAR(50))
						FROM
							EST_TRIB_CONF_GRP_COD_REGRA_GT T
							INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
								T.CD_EMP = RET_TRIB.CD_EMP
								AND T.COD_REGRA = RET_TRIB.COD_REGRA
							INNER JOIN EST_TRIB_CONF_GRP G ON
								T.CD_EMP = G.CD_EMP
								AND T.CD_CTR = G.CD_CTR
						WHERE
							RET_TRIB.CD_CTR = @CD_CTR_PROD
							AND G.CD_REGIAO_FISCAL = @CD_REGIAO_FISCAL;
							

						SET @ACHOU_GRUPO_COD_REGRA = 1
						SET @CRIOU_GRUPO = 1
					END
				END

				IF @ACHOU_GRUPO_COD_REGRA = 0
				BEGIN
					--CRIA O DETALHE DAS REGRAS DO GRUPO NOVO
					INSERT INTO
						EST_TRIB_CONF_GRP_CPL
							(CD_EMP
							,CD_CTR
							,CD_TRIB_CST
							,UF
							,TP_MOV
							,TP_TRANSA
							,TP_LISTA
							,PERC_RED
							,PERC_ICMS
							,TP_RED_BASE_IMP
							,PERC_RED_SUBS_TRIB
							,PERC_RED_ESTORNO
							,CST_PIS
							,CST_COFINS
							,PERC_REPASSE
							,PERC_IBPT
							,TP_GERACAO_DARE
							,MVA_AJUSTADO
							,CD_OPER_MVA
							,PERC_ICMS_ORIGEM
							,PERC_RED_IMPORTADO
							,PERC_RED_SUBS_TRIB_IMPORTADO
							,TIPO_REGIME_EMPRESA
							,OBS_GRUPO_TRIB_NF
							,PERC_ICMS_DIFAL_EXCESSAO
							,FCOP
							,PERC_DIFERIMENTO
							,ORIGEM_TRIB)
					SELECT
						1 AS CD_EMP
						,@CD_CTR_GRP_NOVO AS CD_CTR
						,RET_TRIB.CD_TRIB_CST
						,RET_TRIB.UF
						,RET_TRIB.TP_MOV
						,RET_TRIB.TP_TRANSA
						,EST_TRIB_CONF_GRP.TP_LISTA
						,RET_TRIB.PERC_REDU_BC AS PERC_RED
						,RET_TRIB.ALIQ_ICMS_INTERNA AS PERC_ICMS
						,0 AS TP_RED_BASE_IMP
						,RET_TRIB.PERC_REDU_BC_ST AS PERC_RED_SUBS_TRIB
						,0 AS PERC_RED_ESTORNO
						,RET_TRIB.CST_SAI AS CST_PIS
						,0 AS CST_COFINS
						,0 AS PERC_REPASSE
						,0 AS PERC_IBPT
						,3 AS TP_GERACAO_DARE
						,CASE WHEN RET_TRIB.PERC_IVA_AJUSTADO > 0 THEN 1 ELSE 0 END AS MVA_AJUSTADO
						,RET_TRIB.CD_OPER_MVA
						,RET_TRIB.ALIQ_ICMS_INTERNA AS PERC_ICMS_ORIGEM
						,0 AS PERC_RED_IMPORTADO
						,0 AS PERC_RED_SUBS_TRIB_IMPORTADO
						,RET_TRIB.SIMPLES_NACIONAL AS TIPO_REGIME_EMPRESA
						,'' AS OBS_GRUPO_TRIB_NF
						,0 AS PERC_ICMS_DIFAL_EXCESSAO
						,CASE WHEN RET_TRIB.PERC_FCP = 0 THEN 0 ELSE 1 END AS FCOP
						,RET_TRIB.PERC_DIFERIMENTO AS PERC_DIFERIMENTO
						,1 AS ORIGEM_TRIB
					FROM
						#GT_RETORNO_APLICACAO RET_TRIB
						INNER JOIN EST_TRIB_CONF_GRP ON
							EST_TRIB_CONF_GRP.CD_CTR = @CD_CTR_GRP_NOVO
					WHERE
						RET_TRIB.CD_CTR = @CD_CTR_PROD
						AND NOT EXISTS (
							SELECT
								*
							FROM
								EST_TRIB_CONF_GRP_CPL CPL
							WHERE
								CPL.CD_EMP = RET_TRIB.CD_EMP
								AND CPL.CD_CTR = @CD_CTR_GRP_NOVO
								AND CPL.CD_TRIB_CST = RET_TRIB.CD_TRIB_CST
								AND CPL.UF = RET_TRIB.UF COLLATE SQL_Latin1_General_CP1_CI_AS
								AND CPL.TP_MOV = RET_TRIB.TP_MOV
								AND CPL.TP_TRANSA = RET_TRIB.TP_TRANSA
								AND CPL.CD_OPER_MVA = RET_TRIB.CD_OPER_MVA
								AND CPL.TIPO_REGIME_EMPRESA = RET_TRIB.SIMPLES_NACIONAL)
				END

				--CRIANDO AS INFORMACOES REFERENTES A MVA
				
				SELECT TOP 1 @CFOP = CFOP FROM #GT_RETORNO_APLICACAO WHERE CD_CTR = @CD_CTR_PROD 
				EXEC P_GT_APLICA_TRIBUTACAO_TABELA_MVA @CD_CTR_PROD, @CD_USU, @CD_CTR_GRP_NOVO, @CFOP
				
				FETCH NEXT FROM CURSOR_PRODUTO INTO @CD_CTR_PROD
			END

			CLOSE CURSOR_PRODUTO
			DEALLOCATE CURSOR_PRODUTO
		END

		--APAGA PENDENCIA DE PROCESSAMENTO
		DELETE FROM 
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE
		FROM
			GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE
			INNER JOIN #GT_RETORNO_APLICACAO RET_TRIB ON
				GT_RETORNO_CABECALHO_GRUPOS_PRODUTOS_PENDENTE.CD_CTR = RET_TRIB.CD_CTR_CABECALHO

		COMMIT
	END TRY

	BEGIN CATCH
		ROLLBACK
		SET @ERRO = 'ERRO AO APLICAR TRIBUTAO. ERRO: ' + COALESCE(ERROR_MESSAGE(),'')
		RAISERROR (@ERRO, 16, 1 );
	END CATCH

	--SELECT * FROM #GT_RETORNO_APLICACAO

	DROP TABLE #GT_RETORNO_APLICACAO
	CLOSE CURSOR_GRUPOS
	DEALLOCATE CURSOR_GRUPOS

END
